package gov.va.med.domain.typecode;


/**
 * Type safe enumeration of a proof level.
 * @author Catherine Anderson
 * @version $Id: ProofLevelTypeCode.java,v 1.3 2005/07/05 14:53:16 catherine.anderson Exp $
 */
public class ProofLevelTypeCode extends AlphaNumericTypeCodeAbstract {
	
	
	public static final ProofLevelTypeCode HEAVY_PROOFED = new ProofLevelTypeCode("H", "Authenticated");
	public static final ProofLevelTypeCode IN_PROCESS = new ProofLevelTypeCode("I", "In-Process");
	public static final ProofLevelTypeCode LIGHT_PROOFED = new ProofLevelTypeCode("L", "Not Started");
	public static final ProofLevelTypeCode SUBMITTED = new ProofLevelTypeCode("S", "Submitted");
	public static final ProofLevelTypeCode ALL_PROOF_LVLS = new ProofLevelTypeCode("A", "All");

	private ProofLevelTypeCode(String code, String label) {
		super(code, label);
	}
}
